from __future__ import division
from __future__ import print_function
import os
import glob
import time
import random
import numpy as np
import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torch.autograd import Variable
import pickle
import sys
import datetime
import matplotlib
import csv
matplotlib.use('Agg')
import matplotlib.pyplot as plt

os.environ['KMP_DUPLICATE_LIB_OK']='True'


class ARGS:
    def __init__(self):
        self.cuda = True
        self.seed = int(time.time())
args=ARGS()
random.seed(args.seed)
np.random.seed(args.seed)
torch.manual_seed(args.seed)
if args.cuda:
    torch.cuda.manual_seed(args.seed)



data_path = "C:\\Users\\main_dir_name\\Documents\\or_data\\process\\process\\demand_hr.csv"
plt_path = "C:\\Users\\main_dir_name\\\Documents\\or\\POF_APP1_log\\"


class TwoLayerNN(nn.Module):
    def __init__(self, input_size, hidden_size, output_size):
        super(TwoLayerNN, self).__init__()
        self.fc1 = nn.Linear(input_size, hidden_size)
        self.fc2 = nn.Linear(hidden_size, output_size)

    def forward(self, x):
        m=torch.mean(x, dim=1).reshape(-1,1)
        v=torch.std(x, dim=1).reshape(-1,1)
        
        return torch.cat((m,v), dim=1)




TOTAL_TRAIN_data_array = []
TOTAL_TRAIN_label_data_array = []


total_kky_count=0
nn_output_array_all=[]
label_batch_all = []
nsample = 0
network_fixed_size = 0
nclass = 2
optimizer=[]
model=[]



def load_dataset():
    global TOTAL_TRAIN_data_array, TOTAL_TRAIN_label_data_array, model, optimizer
    data = []
    with open(data_path, mode='r', newline='') as file:
        csv_reader = csv.reader(file)
        
        for row in csv_reader:
            data.append([float(x) if '.' in x else int(x) for x in row])
    TOTAL_TRAIN_data_array=[]
    TOTAL_TRAIN_label_data_array=[]
    for j in range(4):
        tmp=[]
        lab_tmp=[]
        for i in range(len(data)-24):
            tmp2=[]
            for k in range(24):
                tmp2.append(data[i+k][j])
            tmp.append(tmp2)
            lab_tmp.append(data[i+24][j])
        TOTAL_TRAIN_data_array.append(tmp)
        TOTAL_TRAIN_label_data_array.append(lab_tmp)
        model.append(TwoLayerNN(24, 12, nclass+1).cuda())
        optimizer.append(optim.Adam(model[j].parameters()))
        optimizer[j].zero_grad()
    TOTAL_TRAIN_data_array=np.array(TOTAL_TRAIN_data_array)
    TOTAL_TRAIN_label_data_array = np.array(TOTAL_TRAIN_label_data_array)
    print(TOTAL_TRAIN_data_array)
    print(TOTAL_TRAIN_label_data_array)

    return [len(data)-24]



def set_nnparameter(dropout_request, alpha_request, lr_request, weight_decay_request):
    global model, optimizer



def update_nndata(intest_index_array, sample_index, mode):
    global model, nn_output_array_all, label_batch_all, nsample, network_fixed_size, nclass
    nsample = 0
    print("           NN:: the index array length of current training sample: ", len(sample_index))
    label_batch_all=[]
    nn_output_array_all=[]
    for j in range(4):
        if mode == 1:
            model[j].train()
        elif mode == 2:
            model[j].eval()
        else: pass
        data_batch = [TOTAL_TRAIN_data_array[j][i] for i in sample_index]
        data_batch = torch.from_numpy(np.array(data_batch, dtype=np.float32))
        label_batch = [TOTAL_TRAIN_label_data_array[j][i] for i in sample_index]
        label_batch = np.array(label_batch, dtype=np.float32)
        nsample = len(sample_index)
        param = np.array([nclass, nsample])

        
        data_batch = data_batch.cuda()
        nn_output_array = model[j](data_batch)
        nn_output_array_all.append(nn_output_array)
        label_batch_all.append(label_batch)


    label_batch_all=np.array(label_batch_all,dtype=np.float32)
    pReturn1 = param.tolist()
    pReturn2 = label_batch_all.tolist() 
    pReturn3 = [i.cpu().detach().numpy().astype(np.float32).tolist() for i in nn_output_array_all]
    pReturn = [pReturn1, pReturn2, pReturn3]
    return pReturn  

